<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserRole extends Model
{
    protected $table = 'user_roles';
    protected $primaryKey = 'User_role_id';
    public $timestamps = false;

    protected $fillable = [
        'User_id',
        'Role_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'Role_id', 'Role_id');
    }
}
